package de.davidartmann.rosa.model;

import java.io.Serializable;

import de.davidartmann.rosa.db.RosaDbHelper;

/**
 * Model for an entry in the db.
 * Created by david on 29.02.16.
 */
public class Person implements Serializable, Comparable<Person> {

    public static final int SURE = 0;
    public static final int ALMOSTSURE = 1;
    public static final int UNSURE = 2;

    /**
     * Attributes of Object.
     */
    private String name;
    private String address;
    private String phone;
    private String email;
    private String price;
    private String misc;
    private int category;
    private boolean active;
    private String pictureUrl;
    private int position;
    private String tabText;
    private long createTime;
    private long updateTime;
    private int _id;

    /**
     * DB fields of Object.
     */
    public static final String COLUMN_ID = "_id";
    public static final String COLUMN_CREATETIME = "create_time";
    public static final String COLUMN_LASTUPDATE = "last_update";
    public static final String COLUMN_NAME = "name";
    public static final String COLUMN_ADDRESS = "address";
    public static final String COLUMN_PHONE = "phone";
    public static final String COLUMN_EMAIL = "email";
    public static final String COLUMN_PRICE = "price";
    public static final String COLUMN_MISC = "misc";
    public static final String COLUMN_CATEGORY = "category";
    public static final String COLUMN_ACTIVE = "active";
    public static final String COLUMN_PICTUREURL = "picture_url";
    public static final String COLUMN_POSITION = "position";
    public static final String COLUMN_TABTEXT = "tab_text";

    /**
     * Helper to create the table for the persons.
     * Fields which must not be null:
     * - _id
     * - create_time
     * - name
     * - active
     * @return sql stmt for creation of person table.
     */
    public static String createPersonTable() {
        return "create table "
                + RosaDbHelper.TABLE_PERSON + "("
                + COLUMN_ID + " integer primary key autoincrement," //0
                + COLUMN_CREATETIME + " integer not null,"          //1
                + COLUMN_LASTUPDATE + " integer,"                   //2
                + COLUMN_NAME + " text not null,"                   //3
                + COLUMN_ADDRESS + " text,"                         //4
                + COLUMN_PHONE + " text,"                           //5
                + COLUMN_EMAIL + " text,"                           //6
                + COLUMN_PRICE + " text,"                           //7
                + COLUMN_MISC + " text,"                            //8
                + COLUMN_CATEGORY + " integer,"                     //9
                + COLUMN_ACTIVE + " integer not null,"              //10
                + COLUMN_PICTUREURL + " text,"                      //11
                + COLUMN_POSITION + " integer,"                     //12
                + COLUMN_TABTEXT + " text"                          //13
                +");";
    }

    public String getTabText() {
        return tabText;
    }

    public void setTabText(String tabText) {
        this.tabText = tabText;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public int get_id() {
        return _id;
    }

    public void set_id(int _id) {
        this._id = _id;
    }

    public static String[] allColumns = {COLUMN_ID, COLUMN_CREATETIME, COLUMN_LASTUPDATE,
            COLUMN_NAME, COLUMN_ADDRESS, COLUMN_PHONE, COLUMN_EMAIL, COLUMN_PRICE, COLUMN_MISC,
            COLUMN_CATEGORY, COLUMN_ACTIVE, COLUMN_PICTUREURL, COLUMN_POSITION, COLUMN_TABTEXT};

    public boolean isActive() {
        return active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public int getPosition() {
        return position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public String getPictureUrl() {
        return pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public String getMisc() {
        return misc;
    }

    public void setMisc(String misc) {
        this.misc = misc;
    }

    public int getCategory() {
        return category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    @Override
    public int compareTo(Person another) {
        return this.getName().compareToIgnoreCase(another.getName());
    }
}
